define(["angular", "app", "moment"], function (angular, app, moment) {
	"use strict";

	app.controller("FitnessEntryController", function (formatter,$scope, $filter, $state, $stateParams, FitnessRemindersService,
        FitnessService, TrackersConstants, HomePageConstants, FitnessServiceConstants, modalService, focusService, FitnessConstants, WeeklyGoalsService, FitnessCongratsService) {
        
        var service = FitnessService.instance($state.current.data.sectionName),
            goalService = WeeklyGoalsService.instance(),
            congratsService = FitnessCongratsService;




		FitnessRemindersService.init('fitness-activity');
		FitnessRemindersService.getReminder().then(function (response) {
			$scope.notificationDetails = angular.copy(response);
		});
		angular.extend($scope, TrackersConstants["fitness-activity"].entry);


		$scope.entryForm = {
			service: service,
			callbacks: {
				common: function () {
                    returnToSummary();
                },
                save: function(activity) {
                    if($scope.mode === 'Add') {
                        openCongratsModal(activity);
                    } else {
                        returnToSummary();
                    }
                }
			},
			allowedActions: {
				save: true,
				delete: !!$stateParams.id,
				cancel: true
			}
		};
        
        var openCongratsModal = function(activity) {
            var message = reachedNewGoal(activity) ?
                congratsService.getGoalReachedMessage() : congratsService.getStandardMessage();
            
            var modalOptions = {
                closeButtonText: 'Continue',
                headerText: message.title,
                bodyText:   message.text,
                centerBody: true
            };

            modalService.showModal({}, modalOptions).then(function() { }, function() {
                returnToSummary();
            });
        };
        
        var returnToSummary = function() {



            $state.go($state.current.data.backState, $stateParams);
        };
        
        var reachedNewGoal = function(activity) {
            if(! $scope.currentGoal) return false;
            
            return notAlreadyMet('minutes') && wouldMeet('minutes', activity) ||
                   notAlreadyMet('steps')   && wouldMeet('steps', activity) ||
                   notAlreadyMet('miles')   && wouldMeet('miles', activity);
        };
        
        var notAlreadyMet = function(item) {
            var progress = $scope.currentGoal.progress,
                target   = $scope.currentGoal.target;
            
            return (progress && target) ? progress[item] < target[item] : true;
        };
        
        var wouldMeet = function(item, activity) {
            var progress = $scope.currentGoal.progress,
                target   = $scope.currentGoal.target,
                value    = activity.value;
            
            if(! progress) { progress = {minutes: 0, steps: 0, miles: 0}; }
            return (target && value) ? progress[item] + Number(value[item]) >= target[item] : false;
        };

		$scope.sectionTitle = $state.current.data.sectionName;
		$scope.details = $stateParams.id ? angular.copy(service.localGetById($stateParams.id)) : service.createEmpty();
		$scope.allowedDateRange = { min: moment().subtract(6, 'year').format('L') };
		$scope.errorHandling = {
			"requiredFieldSet" 	: { priority: 1, message : 'At least one amount entry is required to save.'}
		};
        $scope.mode = $scope.details.link ? 'Edit' : 'Add';
        $scope.currentGoal = goalService.dataPointers.list[0];

        $scope.$watch('[details, myForm]', function(newVal, oldVal) {
			var formCtrl = angular.element("form[name='myForm']").controller('ngModel');
			if (angular.isDefined(formCtrl)) {
				var validValue = false;
				if (newVal[0].component[0].valueQuantity.value || newVal[0].component[1].valueQuantity.value || newVal[0].extension[1].valueString) {
					validValue = true;
				}
				formCtrl.$setValidity("requiredFieldSet", validValue);
			}
		}, true)

		var openIntensityRatingModal = function() {
			var modalContent = {
				closeButtonText: 'OK',
				headerText: 'Intensity Rating',
				bodyContentUrl: 'src/modules/fitness/pages/entry/fitness-entry-intensity-rating_template.html'
			};

			modalService.showModal({}, modalContent).then(function() {}, function() {
				focusService.focusElement(angular.element('span.btn.btn-icon'));
			});
		};

		$scope.intensityRatingInfo = {
			right : {
				iconLabel : "Intensity Rating",
				icon: "icon-info",
				onClick: openIntensityRatingModal
			}
		};

		if ($scope.details.activeFlag) {

		//	$scope.details.activeFlag.remove('activeFlag');
		//	$scope.details.startDate.remove('startDate');


		}
		var onViewChange = function () {
			focusService.focusPrimary();
		};
		$scope.$on('$viewContentLoaded', onViewChange);
		$scope.$on('$stateChangeSuccess', onViewChange);

		angular.extend($scope, TrackersConstants["fitness-activity"].entry);
	});
});